# -*- coding: utf-8 -*-

import os
from sandbox.projects import resource_types

from sandbox.projects.news.BuildNewsServiceConfigBundleBase import \
    BuildNewsServiceConfigBundleBase,\
    params_for_resources,\
    NewsResourcesArcadiaPath

from sandbox.projects.news.BuildNewsKnockerConfigGenerator import NEWS_KNOCKER_CONFIG_GENERATOR

from sandbox.sandboxsdk.process import run_process


class NEWS_KNOCKER_INSTANCECTL_CONF(resource_types.AbstractResource):
    """
        News knocker inctancectl.conf
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers + ['ssmike']


class NEWS_KNOCKER_CONFIG_PRODUCTION(resource_types.AbstractResource):
    """
        News knocker production config
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers + ['ssmike']


class NEWS_KNOCKER_CONFIG_TESTING(resource_types.AbstractResource):
    """
        News knocker testing config
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers + ['ssmike']


class KnockerConfPath(NewsResourcesArcadiaPath):
    description = 'knocker config url:'
    default_value = 'svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/news/config/knocker/'


def replace(params, param):
    result = []
    for p in params:
        if param.name == p.name:
            result.append(param)
        else:
            result.append(p)
    return result


class BuildNewsKnockerConfigBundle(BuildNewsServiceConfigBundleBase):
    """Build bundle with config files for news knocker"""

    type = "BUILD_NEWS_KNOCKER_CONFIG_BUNDLE"

    input_parameters = replace(BuildNewsServiceConfigBundleBase.input_parameters, KnockerConfPath) \
        + params_for_resources([NEWS_KNOCKER_CONFIG_GENERATOR])

    NEWS_CONFIG_RESOURCES = {
        "instancectl.conf": NEWS_KNOCKER_INSTANCECTL_CONF,
    }

    def on_execute(self):
        BuildNewsServiceConfigBundleBase.on_execute(self)

        config_template = os.path.join(self.get_news_resources_path(), 'conf.json')
        generator = self.sync_resource(self.ctx.get('res_news_knocker_config_generator'))
        workcopy_dir = self.abs_path()

        for env in ['production', 'testing']:
            location = os.path.join(workcopy_dir, 'knocker-{}.conf'.format(env))
            run_process('{} {} --env {} --role master --output {}'
                        .format(generator, config_template, env, location), shell=True)
            resource = self.create_resource(
                description=self.descr,
                resource_path=location,
                resource_type=globals()['NEWS_KNOCKER_CONFIG_' + env.upper()],
                arch=self.arch,
                attributes={},
            )

            self.mark_resource_ready(resource.id)


__Task__ = BuildNewsKnockerConfigBundle
