# -*- coding: utf-8 -*-

from sandbox.projects import resource_types
from sandbox.projects.common.build.CommonBuildTask import CommonBuildTask
from sandbox.projects.common.nanny import nanny

from sandbox.sdk2 import Resource


class NEWS_KNOCKER_CONFIG_GENERATOR(Resource):
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


class BuildNewsKnockerConfigGenerator(nanny.ReleaseToNannyTask, CommonBuildTask):
    """
        Build News knocker config generator
    """

    type = 'BUILD_NEWS_KNOCKER_CONFIG_GENERATOR'

    TARGET_RESOURCES = (
        (NEWS_KNOCKER_CONFIG_GENERATOR, 'yweb/news/knocker/config/knocker-conf-generator'),
    )


__Task__ = BuildNewsKnockerConfigGenerator
