# -*- coding: utf-8 -*-

import os
import logging

from sandbox import sdk2
from sandbox.sandboxsdk.paths import copy_path
from sandbox.projects.news.resources import NEWS_RECOMMENDER_MODELS_PACKAGE, NEWS_RECOMMENDER_MODEL, NEWS_RANKING_MODEL, NEWS_RANKING_MODELS_PACKAGE

from sandbox.projects.common.nanny import nanny


class BuildNewsModelsPackage(nanny.ReleaseToNannyTask2, sdk2.Task):
    '''
        create set of models
    '''

    class Parameters(sdk2.Task.Parameters):
        # FIXME: add required=True or remove this comment (was `reuqired=True`)
        with sdk2.parameters.String("Models resource type", multiline=True) as models_resource_type:
            models_resource_type.values.RECOMMENDER_MODELS_TYPE = "NEWS_RECOMMENDER_MODEL"
            models_resource_type.values.RANKING_MODELS_TYPE = "NEWS_RANKING_MODEL"

        with sdk2.parameters.String('Result resource type', required=True, multiline=True) as result_resource_type:
            result_resource_type.values.RECOMMENDER_BUNDLE_TYPE = "NEWS_RECOMMENDER_MODELS_PACKAGE"
            result_resource_type.values.RANKING_BUNDLE_TYPE = "NEWS_RANKING_MODELS_PACKAGE"

        resource_name = sdk2.parameters.List('Names of resources', required=True, default=[])
        release_type = sdk2.parameters.String('Release type', required=False, default="stable")

    types_mapping = {"RECOMMENDER_MODELS_TYPE": NEWS_RECOMMENDER_MODEL,
                     "RANKING_MODELS_TYPE": NEWS_RANKING_MODEL,
                     "RECOMMENDER_BUNDLE_TYPE": NEWS_RECOMMENDER_MODELS_PACKAGE,
                     "RANKING_BUNDLE_TYPE": NEWS_RANKING_MODELS_PACKAGE
                     }

    def on_execute(self):
        os.makedirs("models")
        for name in self.Parameters.resource_name:
            logging.info("Trying to get " + name + " model")
            attrs = {"name": name, "released": self.Parameters.release_type}
            resource = sdk2.Resource.find(
                self.types_mapping.get(self.Parameters.models_resource_type),
                attrs=attrs).order(-sdk2.Resource.id).first()
            if not resource:
                raise ValueError("No resources with attrs: " + str(attrs))
            resource_data = sdk2.ResourceData(resource)
            path = str(resource_data.path)
            basename = os.path.basename(path)
            copy_path(path, os.path.join("models", basename))
            logging.info(name + " is OK")

        result = self.types_mapping.get(self.Parameters.result_resource_type)(self, "Bundle of models", "models")
        sdk2.ResourceData(result)
