# coding: utf-8

from sandbox import sdk2
from sandbox.projects.common.nanny import nanny
import json

MONTHLY_STORY_COUNT = 5
REQUIRED_FIELDS = ['title', 'transliterated_title', 'cl4url']
MONTHLY_CONFIG_DEFAULT_VALUE = {
    "data": [
        {"cl4url": "", "text": "", "transliterated_title": "", "img": "", "title": ""},
        {"cl4url": "", "transliterated_title": "", "img": "", "title": ""},
        {"cl4url": "", "transliterated_title": "", "img": "", "title": ""},
        {"cl4url": "", "transliterated_title": "", "title": ""},
        {"cl4url": "", "transliterated_title": "", "title": ""}
    ]
}


class NewsMonthlyConfig(sdk2.resource.AbstractResource):
    """
    News monthly config
    """
    releasers = ["k-vukolov", "baymer", "luorlova", "sgrb", "irrra"]
    releasable = True


class BuildNewsMonthlyConfig(nanny.ReleaseToNannyTask2, sdk2.Task):
    """
    Create news monthly config
    """

    class Parameters(sdk2.Task.Parameters):
        monthly_config = sdk2.parameters.JSON("Monthly config", required=True, default=MONTHLY_CONFIG_DEFAULT_VALUE)

    def on_execute(self):
        monthly_config_stories = self.Parameters.monthly_config["data"]

        assert (len(monthly_config_stories) == MONTHLY_STORY_COUNT), 'Story count should be equals to {}'.format(MONTHLY_STORY_COUNT)

        for story in monthly_config_stories:
            for field in REQUIRED_FIELDS:
                assert (field in story), 'Field {} is required'.format(field)

        resource = NewsMonthlyConfig(self, "News monthly rubric config", "monthly_config.json", ttl=30)
        resource_data = sdk2.ResourceData(resource)
        resource_data.path.write_bytes(json.dumps(self.Parameters.monthly_config))
