# -*- coding: utf-8 -*-

from sandbox.projects.common.build.CommonBuildTask import CommonBuildTask
from sandbox.projects.common.nanny import nanny
from sandbox.projects.news.resources import NEWS_OFF_STATEMENT_RUNTIME_EXPORTER_EXECUTABLE


class BuildNewsOffStatementRuntimeExporter(nanny.ReleaseToNannyTask, CommonBuildTask):
    """
        Build News OffStatement Runtime Exporter
    """

    type = 'BUILD_NEWS_OFF_STATEMENT_RUNTIME_EXPORTER'

    TARGET_RESOURCES = (
        (NEWS_OFF_STATEMENT_RUNTIME_EXPORTER_EXECUTABLE, 'yweb/news/data_flow/services/official_statement/runtime_export/service/service'),
    )

    def do_execute(self):
        CommonBuildTask.do_execute(self)


__Task__ = BuildNewsOffStatementRuntimeExporter
