# -*- coding: utf-8 -*-

from sandbox.projects.news import resources

from sandbox.projects.common.nanny import nanny
from sandbox.sandboxsdk.copy import RemoteCopy
from sandbox import sdk2

FILES = {
    "surveys_configs.json": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/news/services/app_host/news_proxy/surveys_configs.json"
}


class BuildNewsProxySurveysConfigs(nanny.ReleaseToNannyTask2, sdk2.Task):
    """
        Get surveys_configs.json
    """

    class Parameters(sdk2.Task.Parameters):
        svn_revision = sdk2.parameters.Integer("SVN revision", required=True)

    def download_file(self, src, dst):
        RemoteCopy(src, dst,
                   log_dir=self.log_path())(timeout=RemoteCopy.DEFAULT_TIMEOUT)

    def on_execute(self):
        for filename, src_path in FILES.iteritems():
            self.download_file(src_path + "@" + str(self.Parameters.svn_revision), filename)

        presets = sdk2.ResourceData(resources.NEWS_PROXY_SURVEYS_CONFIGS(self, "surveys_configs.json for surveys", "surveys_configs.json", ttl=28))
        presets.ready()
