# -*- coding: utf-8 -*-

from sandbox.projects.news import resources

from sandbox.projects.common.nanny import nanny
from sandbox.sandboxsdk.copy import RemoteCopy
from sandbox import sdk2

PERL_SCRIPTS = {
    "quotes.pl": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/news/report/scripts/news/quotes.pl",
    "quotes-rates-variables.pl": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/news/report/scripts/news/quotes-rates-variables.pl"
}


class BuildNewsQuotesScripts(nanny.ReleaseToNannyTask2, sdk2.Task):
    """
        Gather News.Quotes perl scripts for nginx
    """

    class Parameters(sdk2.Task.Parameters):
        svn_revision = sdk2.parameters.Integer("SVN revision", required=True)

    def download_file(self, src, dst):
        RemoteCopy(src, dst,
                   log_dir=self.log_path())(timeout=RemoteCopy.DEFAULT_TIMEOUT)

    def on_execute(self):
        for filename, src_path in PERL_SCRIPTS.iteritems():
            self.download_file(src_path + "@" + str(self.Parameters.svn_revision), filename)

        quotesResource = sdk2.ResourceData(resources.NEWS_QUOTES_SCRIPT(self, "quotes.pl script for generating quotes near nginx", "quotes.pl", ttl=28))
        quotesResource.ready()

        quotesHelperResource = sdk2.ResourceData(resources.NEWS_QUOTES_RATES_VARS_SCRIPT(self, "quotes helper script", "quotes-rates-variables.pl", ttl=28))
        quotesHelperResource.ready()
