# -*- coding: utf-8 -*-

import sandbox.projects.common.build.YaPackage as pkg
import sandbox.projects.common.build.parameters as build_parameters
from sandbox.projects.common.news.parameters import replace_parameters_default_value
from sandbox.projects.news.resources import NEWS_RANKING_MODELS_PACKAGE


class BuildNewsRankingModelsPackage(pkg.YaPackage):
    """
        Build news ranking models package and config
    """

    type = 'BUILD_NEWS_RANKING_MODELS_PACKAGE'

    input_parameters = replace_parameters_default_value(pkg.YaPackage.input_parameters, {
        pkg.ResourceTypeParameter: NEWS_RANKING_MODELS_PACKAGE.name,
        pkg.PackagesParameter: "yweb/news/rank/data/news_ranking_formulas_package.json",
        pkg.PackageTypeParameter: pkg.TARBALL,
        pkg.RawPackageParameter: True,
        pkg.UseNewFormatParameter: True,

        build_parameters.UseArcadiaApiFuse: True,
        build_parameters.UseArcInsteadOfArcadiaApi: True,
        build_parameters.AllowArcadiaApiFallback: True,
        build_parameters.BuildType: "release",

        pkg.PublishPackageParameter: False,
    })


__Task__ = BuildNewsRankingModelsPackage
