# -*- coding: utf-8 -*-

from sandbox.sdk2.resource import AbstractResource

from sandbox.projects import resource_types
from sandbox.projects.news.BuildNewsAppHostServiceBase import BuildNewsAppHostServiceBase


class NEWS_REARRANGED_EXECUTABLE(AbstractResource):
    """"""
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


class BuildNewsRearranged(BuildNewsAppHostServiceBase):
    """"""

    type = 'BUILD_NEWS_REARRANGED'

    TARGET_RESOURCES = (
        (NEWS_REARRANGED_EXECUTABLE, 'yweb/news/app_host/rearranged/news_apphost_rearranged'),
        (resource_types.EVLOGDUMP_EXECUTABLE, 'yweb/news/app_host/rearranged/evlogdump/evlogdump_rearranged'),
    )


__Task__ = BuildNewsRearranged
