# -*- coding: utf-8 -*-

from sandbox.projects.news import resources

from sandbox.sandboxsdk.channel import channel

from sandbox.projects.common import breakpad
from sandbox.projects.common.build.CommonBuildTask import CommonBuildTask
from sandbox.projects.common.nanny import nanny


class BuildNewsRemoteLogger(nanny.ReleaseToNannyTask, CommonBuildTask):
    """
        Build NEWS_REMOTE_LOGGER daemon
    """

    type = 'BUILD_NEWS_REMOTE_LOGGER'

    TARGET_RESOURCES = (
        (resources.NEWS_REMOTE_LOGGER_EXECUTABLE, 'yweb/news/remote_logger'),
    )

    def do_execute(self):
        CommonBuildTask.do_execute(self)
        res = channel.sandbox.get_resource(self._target_resource_id('news_remote_logger'))
        breakpad.dump_symbols(res)


__Task__ = BuildNewsRemoteLogger
