import os
import shutil

from sandbox import sdk2
from sandbox.sandboxsdk.svn import Arcadia


RUN_DIRECTORY_NAME = "run"
ARCADIA_RUN_DIRECTORY_NAME = "arcadia_run"

GEN_CONFIG_FILENAMES = ["gen_mongo_conf.sh", "gen_zk_conf.sh"]
RKN_RUN_SCRIPTS_PATH = "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/news/services/rkn_viewer/run"


def copy_with_rename(src, dest, filename, new_name=None):
    if new_name is None:
        new_name = filename

    shutil.copyfile(os.path.join(src, filename), os.path.join(dest, new_name))


class BuildNewsRknRunBundle(sdk2.Task):
    bundle_resource_type = None
    run_script_filename = None

    def on_execute(self):
        Arcadia.export(RKN_RUN_SCRIPTS_PATH, ARCADIA_RUN_DIRECTORY_NAME)

        bundle_resource_data = sdk2.ResourceData(type(self).bundle_resource_type(
            self, 'Run scripts for rkn viewer', RUN_DIRECTORY_NAME
        ))
        bundle_resource_data.path.mkdir()

        for filename in GEN_CONFIG_FILENAMES:
            copy_with_rename(ARCADIA_RUN_DIRECTORY_NAME, RUN_DIRECTORY_NAME, filename)

        copy_with_rename(ARCADIA_RUN_DIRECTORY_NAME, RUN_DIRECTORY_NAME, type(self).run_script_filename, "run.sh")

        bundle_resource_data.ready()
