# -*- coding: utf-8 -*-

from sandbox import sdk2
from sandbox.projects import resource_types
from sandbox.projects.news.BuildNewsServiceConfigBundleBase import BuildNewsServiceConfigBundleBase


class NEWS_ROBOT_ARTICLES_TRANSPORT_CONFIG(sdk2.Resource):
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


class BuildNewsRobotArticlesProcessorConfigs(BuildNewsServiceConfigBundleBase):
    """Build bundle with config files and scripts for Nanny service of news news_robot_articles_processor"""

    type = "BUILD_NEWS_ROBOT_ARTICLES_PROCESSOR_CONFIGS"

    NEWS_CONFIG_RESOURCES = {
        "config.pbtxt.tmpl": NEWS_ROBOT_ARTICLES_TRANSPORT_CONFIG
    }


__Task__ = BuildNewsRobotArticlesProcessorConfigs
