# -*- coding: utf-8 -*-

from sandbox.sdk2.resource import AbstractResource

from sandbox.projects import resource_types
from sandbox.projects.news.BuildNewsAppHostServiceBase import BuildNewsAppHostServiceBase


class NEWS_SCARLOGD_EXECUTABLE(AbstractResource):
    """"""
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


class BuildNewsScarlogd(BuildNewsAppHostServiceBase):
    """"""

    type = 'BUILD_NEWS_SCARLOGD'

    TARGET_RESOURCES = (
        (NEWS_SCARLOGD_EXECUTABLE, 'yweb/news/app_host/scarlogd/news_apphost_scarlogd'),
        (resource_types.EVLOGDUMP_EXECUTABLE, 'yweb/news/app_host/scarlogd/evlogdump/evlogdump_scarlogd'),
    )

    TARGET_TO_DUMP_SYMBOLS = 'news_apphost_scarlogd'


__Task__ = BuildNewsScarlogd
