# -*- coding: utf-8 -*-

from sandbox.projects.news import resources

from sandbox.projects.common.nanny import nanny
from sandbox.sandboxsdk.copy import RemoteCopy
from sandbox import sdk2


class BuildNewsSheNewsDataConfig(nanny.ReleaseToNannyTask2, sdk2.Task):
    """
        Gather she_news_data.json config for NewsDataAAS
    """

    class Parameters(sdk2.Task.Parameters):
        svn_revision = sdk2.parameters.Integer("SVN revision", required=True)

    def download_file(self, src, dst):
        RemoteCopy(src, dst,
                   log_dir=self.log_path())(timeout=RemoteCopy.DEFAULT_TIMEOUT)

    def on_execute(self):
        self.download_file("svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/news/services/app_host/news_data_aas/she_news_data.json@" + str(self.Parameters.svn_revision), "she_news_data.json")

        sheNewsDataResource = sdk2.ResourceData(resources.NEWS_SHE_NEWS_DATA_CONF(self, "she_news_data config", "she_news_data.json", ttl=28))
        sheNewsDataResource.ready()
