# -*- coding: utf-8 -*-

from sandbox.sdk2.resource import AbstractResource

from sandbox.projects import resource_types
from sandbox.projects.news.BuildNewsServiceConfigBundleBase import BuildNewsServiceConfigBundleBase


class NEWS_SPORT_ADMIN_NGINX_CONFIG(AbstractResource):
    """"""
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = resource_types.news_service_config_releasers


class NEWS_SPORT_ADMIN_NGINX_WORKER_LUA(AbstractResource):
    """"""
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = resource_types.news_service_config_releasers


class NEWS_SPORT_ADMIN_NGINX_METRICS_LUA(AbstractResource):
    """"""
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = resource_types.news_service_config_releasers


class BuildNewsSportAdminNginxServiceConfigBundle(BuildNewsServiceConfigBundleBase):
    """Build bundle with config files and scripts for Nanny service of sport admin"""

    type = "BUILD_NEWS_SPORT_ADMIN_NGINX_SERVICE_CONFIG_BUNDLE"

    NEWS_CONFIG_RESOURCES = {
        "nginx-news.conf": NEWS_SPORT_ADMIN_NGINX_CONFIG,
        "worker.lua": NEWS_SPORT_ADMIN_NGINX_WORKER_LUA,
        "metrics.lua": NEWS_SPORT_ADMIN_NGINX_METRICS_LUA,
    }


__Task__ = BuildNewsSportAdminNginxServiceConfigBundle
