# -*- coding: utf-8 -*-

from sandbox.projects.news import resources

from sandbox.projects.common.nanny import nanny
from sandbox.sandboxsdk.copy import RemoteCopy
from sandbox import sdk2

FILES = {
    "sport_setup_config.json": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/news/services/app_host/news_data_aas/sport_setup_config.json"
}


class BuildNewsSportSetupConf(nanny.ReleaseToNannyTask2, sdk2.Task):
    """
        Gather sport_setup_config.json file
    """

    class Parameters(sdk2.Task.Parameters):
        svn_revision = sdk2.parameters.Integer("SVN revision", required=True)

    def download_file(self, src, dst):
        RemoteCopy(src, dst,
                   log_dir=self.log_path())(timeout=RemoteCopy.DEFAULT_TIMEOUT)

    def on_execute(self):
        for filename, src_path in FILES.iteritems():
            self.download_file(src_path + "@" + str(self.Parameters.svn_revision), filename)

        resourceConfig = sdk2.ResourceData(resources.NEWS_SPORT_SETUP_CONF(self, "sport_setup_config.json for news_data_aas", "sport_setup_config.json", ttl=28))
        resourceConfig.ready()
