# -*- coding: utf-8 -*-

from sandbox.projects.news import resources

from sandbox.projects.common.nanny import nanny
from sandbox.sandboxsdk.copy import RemoteCopy
from sandbox import sdk2


class BuildNewsSportVideoCarouselsConfig(nanny.ReleaseToNannyTask2, sdk2.Task):
    """
        Gather sport_video_carousels.json config for NewsDataAAS
    """

    class Parameters(sdk2.Task.Parameters):
        svn_revision = sdk2.parameters.Integer("SVN revision", required=True)

    def download_file(self, src, dst):
        RemoteCopy(src, dst,
                   log_dir=self.log_path())(timeout=RemoteCopy.DEFAULT_TIMEOUT)

    def on_execute(self):
        self.download_file("svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/news/services/app_host/news_data_aas/sport_video_carousels.json@" +
                           str(self.Parameters.svn_revision), "sport_video_carousels.json")

        sportVideoCarouselsResource = sdk2.ResourceData(resources.SPORT_VIDEO_CAROUSELS(self, "sport_video_carousels config", "sport_video_carousels.json", ttl=28))
        sportVideoCarouselsResource.ready()
