# -*- coding: utf-8 -*-

from sandbox.projects import resource_types
from sandbox.projects.common.build.CommonBuildTask import CommonBuildTask


class NEWS_STANDALONE_ANNOTATOR_EXECUTABLE(resource_types.AbstractResource):
    """
        News standalone annotator executable
    """
    executable = True
    any_arch = False


class BuildNewsStandaloneAnnotator(CommonBuildTask):
    """
        Build News annotator
    """

    type = 'BUILD_NEWS_STANDALONE_ANNOTATOR'

    TARGET_RESOURCES = (
        (NEWS_STANDALONE_ANNOTATOR_EXECUTABLE, 'yweb/news/annotator/main/annotator'),
    )

    def do_execute(self):
        CommonBuildTask.do_execute(self)


__Task__ = BuildNewsStandaloneAnnotator
