# -*- coding: utf-8 -*-

from sandbox.projects.news import resources

from sandbox.projects.common.nanny import nanny
from sandbox.sandboxsdk.copy import RemoteCopy
from sandbox import sdk2

FILES = {
    "news_static_data.json": "svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/news/services/app_host/news_static_data/news_static_data.json"
}


class BuildNewsStaticDataParams(nanny.ReleaseToNannyTask2, sdk2.Task):
    """
        Get news_static_data.json
    """

    class Parameters(sdk2.Task.Parameters):
        svn_revision = sdk2.parameters.Integer("SVN revision", required=True)

    def download_file(self, src, dst):
        RemoteCopy(src, dst,
                   log_dir=self.log_path())(timeout=RemoteCopy.DEFAULT_TIMEOUT)

    def on_execute(self):
        for filename, src_path in FILES.iteritems():
            self.download_file(src_path + "@" + str(self.Parameters.svn_revision), filename)

        static_data = sdk2.ResourceData(resources.NEWS_STATIC_DATA_PARAMS(self, "news_static_data.json for api", "news_static_data.json", ttl=28))
        static_data.ready()
