# -*- coding: utf-8 -*-

from sandbox.projects import resource_types
from sandbox.projects.common.build.CommonBuildTask import CommonBuildTask
from sandbox.projects.common.nanny import nanny

from sandbox.sdk2 import Resource as AbstractResource


class NEWS_STORAGE_DUMPER_EXECUTABLE(AbstractResource):
    """
        News storage dumper executable
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


class BuildNewsStorageDumper(nanny.ReleaseToNannyTask, CommonBuildTask):
    """
        Build News storage dumper
    """

    type = 'BUILD_NEWS_STORAGE_DUMPER'

    TARGET_RESOURCES = (
        (NEWS_STORAGE_DUMPER_EXECUTABLE, 'yweb/news/storage/yt/dumper/dumper'),
    )

    def do_execute(self):
        CommonBuildTask.do_execute(self)


__Task__ = BuildNewsStorageDumper
