# -*- coding: utf-8 -*-

from sandbox.projects import resource_types
from sandbox.projects.news.BuildNewsServiceConfigBundleBase import BuildNewsServiceConfigBundleBase


class NEWS_STORAGE_DUMPER_INSTANCECTL_CONF(resource_types.AbstractResource):
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


class NEWS_STORAGE_DUMPER_CONFIG(resource_types.AbstractResource):
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


class BuildNewsStorageDumperConfigBundle(BuildNewsServiceConfigBundleBase):
    """Build bundle with config files for news storage dumper"""

    type = "BUILD_NEWS_STORAGE_DUMPER_CONFIG_BUNDLE"

    NEWS_CONFIG_RESOURCES = {
        "instancectl.conf": NEWS_STORAGE_DUMPER_INSTANCECTL_CONF,
        "conf.json": NEWS_STORAGE_DUMPER_CONFIG
    }


__Task__ = BuildNewsStorageDumperConfigBundle
