# -*- coding: utf-8 -*-

from sandbox.projects import resource_types
from sandbox.projects.news.BuildNewsServiceConfigBundleBase import BuildNewsServiceConfigBundleBase
from sandbox.projects.common.BaseReportShardTask import getClassesByResources
import os

from sandbox.sandboxsdk.process import run_process


class BuildNewsStorageReplicatorConfigs(BuildNewsServiceConfigBundleBase):
    """Build bundle with config files for news storage replicator"""

    type = "BUILD_NEWS_STORAGE_REPLICATOR_CONFIGS"

    input_parameters = BuildNewsServiceConfigBundleBase.input_parameters + getClassesByResources(['NEWS_STORAGE_REPLICATOR_CONFIG_GENERATOR'])

    NEWS_CONFIG_RESOURCES = {
        "instancectl.conf": resource_types.NEWS_STORAGE_REPLICATOR_INSTANCECTL_CONF
    }

    def on_execute(self):
        BuildNewsServiceConfigBundleBase.on_execute(self)

        config_template = os.path.join(self.get_news_resources_path(), 'template')
        generator = self.sync_resource(self.ctx.get('res_news_storage_replicator_config_generator'))
        workcopy_dir = self.abs_path()

        run_process('{} {} {}'.format(generator, config_template, workcopy_dir), shell=True)

        for suffix in ['production', 'testing']:
            resource = self.create_resource(
                description=self.descr,
                resource_path=suffix + '.indexer.conf',
                resource_type=getattr(resource_types, 'NEWS_STORAGE_REPLICATOR_CONFIG_' + suffix.upper()),
                arch=self.arch,
                attributes={},
            )

            self.mark_resource_ready(resource.id)


__Task__ = BuildNewsStorageReplicatorConfigs
