# -*- coding: utf-8 -*-

from sandbox.projects import resource_types
from sandbox.projects.common.build.CommonBuildTask import CommonBuildTask
from sandbox.sdk2 import Resource as AbstractResource


class NEWS_STORAGE_TRIMMER_EXECUTABLE(AbstractResource):
    """
        News storage trimmer executable
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


class BuildNewsStorageTrimmer(CommonBuildTask):
    """
        Build News storage trimmer
    """

    type = 'BUILD_NEWS_STORAGE_TRIMMER'

    TARGET_RESOURCES = (
        (NEWS_STORAGE_TRIMMER_EXECUTABLE, 'yweb/news/storage/yt/trimmer/trimmer'),
    )


__Task__ = BuildNewsStorageTrimmer
