# -*- coding: utf-8 -*-

from sandbox.projects import resource_types
from sandbox.projects.news.BuildNewsServiceConfigBundleBase import \
    BuildNewsServiceConfigBundleBase, \
    NewsResourcesArcadiaPath


class TrimmerConfPath(NewsResourcesArcadiaPath):
    description = 'trimmer config bundle:'
    default_value = 'svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/yweb/news/services/storage_trimmer'


def replace(params, param):
    result = []
    for p in params:
        if param.name == p.name:
            result.append(param)
        else:
            result.append(p)
    return result


class NEWS_STORAGE_TRIMMER_CONFIG(resource_types.AbstractResource):
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


class BuildNewsStorageTrimmerConfigBundle(BuildNewsServiceConfigBundleBase):
    """Build bundle with config files for news storage trimmer"""

    type = "BUILD_NEWS_STORAGE_TRIMMER_CONFIG_BUNDLE"

    input_parameters = replace(BuildNewsServiceConfigBundleBase.input_parameters, TrimmerConfPath) \

    NEWS_CONFIG_RESOURCES = {
        "conf.json": NEWS_STORAGE_TRIMMER_CONFIG
    }


__Task__ = BuildNewsStorageTrimmerConfigBundle
