# -*- coding: utf-8 -*-

from sandbox.projects import resource_types
import sandbox.projects.common.build.YaPackage as pkg
from sandbox.projects.common.nanny import nanny
from sandbox.projects.news import news_quality
import sandbox.projects.common.build.parameters as build_parameters
from sandbox.projects.common.news.parameters import replace_parameters_default_value


class NEWS_SUMMARIZER_DATA_PACKAGE(resource_types.AbstractResource):
    """
        News summury data package
    """
    releasable = True
    auto_backup = True
    releasers = resource_types.news_releasers + news_quality


class BuildNewsSummarizerDataPackage(nanny.ReleaseToNannyTask, pkg.YaPackage):
    """
        Build News summarizer
    """

    type = 'BUILD_NEWS_SUMMARIZER_DATA_PACKAGE'

    input_parameters = replace_parameters_default_value(pkg.YaPackage.input_parameters, {
        pkg.ResourceTypeParameter: NEWS_SUMMARIZER_DATA_PACKAGE.name,
        pkg.PackagesParameter: "yweb/news/rt_robot/pkg/summarizer_data_package.json",
        pkg.PackageTypeParameter: pkg.TARBALL,
        pkg.CompressPackageArchiveParameter: False,
        pkg.UseNewFormatParameter: True,

        build_parameters.UseArcadiaApiFuse: True,
        build_parameters.UseArcInsteadOfArcadiaApi: True,
        build_parameters.AllowArcadiaApiFallback: True,
        build_parameters.BuildType: "release",
    })


__Task__ = BuildNewsSummarizerDataPackage
