# -*- coding: utf-8 -*-

from sandbox import sdk2
from sandbox.projects import resource_types
from sandbox.projects.news.BuildNewsServiceConfigBundleBase import BuildNewsServiceConfigBundleBase


class NEWS_SUMMARY_DOC_TO_CLUSTER_MAPPER_RUN_TEMPLATE(sdk2.Resource):
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


class NEWS_SUMMARY_DOC_TO_CLUSTER_MAPPER_CONFIG(sdk2.Resource):
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


class BuildNewsSummaryDocToClusterMapperServiceConfigs(BuildNewsServiceConfigBundleBase):
    """Build bundle with config files and scripts for Nanny service of news summary_doc_to_cluster_mapper"""

    type = "BUILD_NEWS_SUMMARY_DOC_TO_CLUSTER_MAPPER_SERVICE_CONFIGS"

    NEWS_CONFIG_RESOURCES = {
        "run_template.sh": NEWS_SUMMARY_DOC_TO_CLUSTER_MAPPER_RUN_TEMPLATE,
        "config.pbtxt.tmpl": NEWS_SUMMARY_DOC_TO_CLUSTER_MAPPER_CONFIG,
    }


__Task__ = BuildNewsSummaryDocToClusterMapperServiceConfigs
