# -*- coding: utf-8 -*-

from sandbox import sdk2
from sandbox.projects import resource_types
from sandbox.projects.news.BuildNewsServiceConfigBundleBase import BuildNewsServiceConfigBundleBase


class NEWS_SUMMARY_DOC_UPDATES_MERGER_RUN_TEMPLATE(sdk2.Resource):
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


class NEWS_SUMMARY_DOC_UPDATES_MERGER_CONFIG(sdk2.Resource):
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


class BuildNewsSummaryDocUpdatesMergerServiceConfigs(BuildNewsServiceConfigBundleBase):
    """Build bundle with config files and scripts for Nanny service of news summary_doc_updates_merger"""

    type = "BUILD_NEWS_SUMMARY_DOC_UPDATES_MERGER_SERVICE_CONFIGS"

    NEWS_CONFIG_RESOURCES = {
        "run_template.sh": NEWS_SUMMARY_DOC_UPDATES_MERGER_RUN_TEMPLATE,
        "config.pbtxt.tmpl": NEWS_SUMMARY_DOC_UPDATES_MERGER_CONFIG,
    }


__Task__ = BuildNewsSummaryDocUpdatesMergerServiceConfigs
