# -*- coding: utf-8 -*-

from sandbox import sdk2
from sandbox.projects import resource_types
from sandbox.projects.news.BuildNewsServiceConfigBundleBase import BuildNewsServiceConfigBundleBase
from sandbox.projects.common.nanny import nanny
from sandbox.sandboxsdk import parameters
from sandbox.sandboxsdk import sandboxapi


class NEWS_SUMMARY_PROCESSOR_RUN_TEMPLATE(sdk2.Resource):
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


class NEWS_SUMMARY_PROCESSOR_CONFIG(sdk2.Resource):
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


class NEWS_SUMMARY_PROCESSOR_EXP_CONFIG(sdk2.Resource):
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


class NEWS_SUMMARY_PROCESSOR_CLUSTERING_EXP_CONFIG(sdk2.Resource):
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


class NEWS_SUMMARY_SUMMARIZER_RUN_TEMPLATE(sdk2.Resource):
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


class NEWS_SUMMARY_SUMMARIZER_BASE_CONFIG(sdk2.Resource):
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


class NEWS_SUMMARY_SUMMARIZER_CONFIG(sdk2.Resource):
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


class NEWS_SUMMARY_SUMMARIZER_EXP_CONFIG(sdk2.Resource):
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


class NEWS_SUMMARY_SUMMARIZER_CLUSTERING_EXP_CONFIG(sdk2.Resource):
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


class NEWS_SUMMARY_PROCESSOR_PQ_WRITER_CONFIG(sdk2.Resource):
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


class NEWS_SUMMARY_PROCESSOR_PQ_WRITER_EXP_CONFIG(sdk2.Resource):
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


class NEWS_SUMMARY_NORMALIZER_RESOURCE(sdk2.Resource):
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


class NEWS_SUMMARY_NORMALIZER_CONFIG(sdk2.Resource):
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


class BuildNewsSummaryProcessorServiceConfigs(BuildNewsServiceConfigBundleBase):
    """Build bundle with config files and scripts for Nanny service of news summary_processor"""

    class ReleaseTo(parameters.SandboxStringParameter):
        name = 'release_to'
        choices = [('do not release', '')] + [(x, x) for x in sandboxapi.RELEASE_STATUSES]
        description = 'Release resource to'
        default_value = ''

    type = "BUILD_NEWS_SUMMARY_PROCESSOR_SERVICE_CONFIGS"

    NEWS_CONFIG_RESOURCES = {
        "run_processor.sh": NEWS_SUMMARY_PROCESSOR_RUN_TEMPLATE,
        "run_summarizer.sh": NEWS_SUMMARY_SUMMARIZER_RUN_TEMPLATE,
        "processor_config.pbtxt.tmpl": NEWS_SUMMARY_PROCESSOR_CONFIG,
        "processor_config_exp.pbtxt.tmpl": NEWS_SUMMARY_PROCESSOR_EXP_CONFIG,
        "processor_config_clustering_exp.pbtxt.tmpl": NEWS_SUMMARY_PROCESSOR_CLUSTERING_EXP_CONFIG,
        "summarizer_config_base.pbtxt": NEWS_SUMMARY_SUMMARIZER_BASE_CONFIG,
        "summarizer_config.pbtxt": NEWS_SUMMARY_SUMMARIZER_CONFIG,
        "summarizer_config_exp.pbtxt": NEWS_SUMMARY_SUMMARIZER_EXP_CONFIG,
        "summarizer_config_clustering_exp.pbtxt": NEWS_SUMMARY_SUMMARIZER_CLUSTERING_EXP_CONFIG,
        "pq_writer.pbtxt.tmpl": NEWS_SUMMARY_PROCESSOR_PQ_WRITER_CONFIG,
        "pq_writer_exp.pbtxt.tmpl": NEWS_SUMMARY_PROCESSOR_PQ_WRITER_EXP_CONFIG,
        "normalizer_resource.json": NEWS_SUMMARY_NORMALIZER_RESOURCE,
        "normalizer_config.json": NEWS_SUMMARY_NORMALIZER_CONFIG,
    }

    input_parameters = BuildNewsServiceConfigBundleBase.input_parameters + [ReleaseTo]

    def on_success(self):
        BuildNewsServiceConfigBundleBase.on_success(self)
        if self.ctx[self.ReleaseTo.name]:
            additional_parameters = dict(
                releaser=self.author,
                release_status=self.ctx[self.ReleaseTo.name],
                release_subject='Automatic release',
                email_notifications=dict(to=[], cc=[]),
            )
            nanny.ReleaseToNannyTask.on_release(self, additional_parameters)


__Task__ = BuildNewsSummaryProcessorServiceConfigs
