# -*- coding: utf-8 -*-

import __builtin__
import os
from sandbox import sdk2
from sandbox.projects import resource_types
from sandbox.projects.common.build.CommonBuildTask import CommonBuildTask
from sandbox.projects.common.nanny import nanny
from sandbox.projects.news import news_quality
from sandbox.sandboxsdk import parameters
from sandbox.sandboxsdk import sandboxapi


class NEWS_SUMMARY_DOC_UPDATES_MERGER(sdk2.Resource):
    """
        Reads multiple data sources for in write all data in YT queue
        Also done resharding (key is document url)
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


class NEWS_SUMMARY_DOC_TO_CLUSTER_MAPPER(sdk2.Resource):
    """
        Read updates of document and update it state (with last update of each part)
        Write updates for cluster with content of the document
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


class NEWS_SUMMARY_CLUSTER_STATE_UPDATER(sdk2.Resource):
    """
        Aggregates state of each cluster
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


class NEWS_SUMMARY_SUMMARY_PROCESSOR(sdk2.Resource):
    """
        Constructing request to summarizer
        Also done all transport related work for summarizer
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


class NEWS_SUMMARY_HTTP_SUMMARIZER(sdk2.Resource):
    """
        Summarizer with HTTP interface
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


class NEWS_SUMMARY_TOLOKA_PREPROCESSOR(sdk2.Resource):
    """
        Merge all data required for toloka processor in one queue
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


class NEWS_SUMMARY_TOLOKA_PROCESSOR(sdk2.Resource):
    """
        Write toloka request for top summaries
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


class NEWS_SUMMARY_YT_UPDATER(sdk2.Resource):
    """
        Read summaries and toloka results and write data for runtime on YT
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


def target2field_name(target):
    return 'build_%s' % target


class BuildNewsSummaryServices(nanny.ReleaseToNannyTask, CommonBuildTask):
    """
        Build News summary services
    """

    type = 'BUILD_NEWS_SUMMARY_SERVICES'

    TARGET_RESOURCES = (
        (NEWS_SUMMARY_DOC_UPDATES_MERGER, 'yweb/news/rt_robot/processors/doc_updates_merger/doc_updates_merger'),
        (NEWS_SUMMARY_DOC_TO_CLUSTER_MAPPER, 'yweb/news/rt_robot/processors/doc_to_cluster_mapper/doc_to_cluster_mapper'),
        (NEWS_SUMMARY_CLUSTER_STATE_UPDATER, 'yweb/news/rt_robot/processors/cluster_state_updater/cluster_state_updater'),
        (NEWS_SUMMARY_SUMMARY_PROCESSOR, 'yweb/news/rt_robot/processors/summary_processor/summary_processor'),
        (NEWS_SUMMARY_HTTP_SUMMARIZER, 'yweb/news/rt_robot/summarizer/http_server/http_server'),
        (NEWS_SUMMARY_TOLOKA_PREPROCESSOR, 'yweb/news/rt_robot/processors/toloka_preprocessor/toloka_preprocessor'),
        (NEWS_SUMMARY_TOLOKA_PROCESSOR, 'yweb/news/rt_robot/processors/toloka_processor/toloka_processor'),
        (NEWS_SUMMARY_YT_UPDATER, 'yweb/news/rt_robot/yt_writer/yt_writer'),
    )

    class SummaryBinaries(parameters.SandboxInfoParameter):
        name = 'summarizer_binaries'
        description = 'Summary Binaries'

    input_parameters = [SummaryBinaries]

    for _, path in TARGET_RESOURCES:
        target = os.path.basename(path)
        field_name = target2field_name(target)
        input_parameters.extend([__builtin__.type(
            field_name,
            (parameters.SandboxBoolParameter,),
            dict(name=field_name, description=target, default_value=False),
        )])

    class MainParameters(parameters.SandboxInfoParameter):
        name = 'main_parameters'
        description = 'Common Build Task parameters'

    class ReleaseTo(parameters.SandboxStringParameter):
        name = 'release_to'
        choices = [('do not release', '')] + [(x, x) for x in sandboxapi.RELEASE_STATUSES]
        description = 'Release resource to'
        default_value = ''

    input_parameters += [MainParameters] + CommonBuildTask.input_parameters + [ReleaseTo]

    def do_execute(self):
        CommonBuildTask.do_execute(self)

    def on_success(self):
        CommonBuildTask.on_success(self)
        if self.ctx[self.ReleaseTo.name]:
            additional_parameters = dict(
                releaser=self.author,
                release_status=self.ctx[self.ReleaseTo.name],
                release_subject='Automatic release',
                email_notifications=dict(to=[], cc=[]),
            )
            nanny.ReleaseToNannyTask.on_release(self, additional_parameters)


__Task__ = BuildNewsSummaryServices
