# -*- coding: utf-8 -*-

from sandbox import sdk2
from sandbox.projects import resource_types
from sandbox.projects.news.BuildNewsServiceConfigBundleBase import BuildNewsServiceConfigBundleBase


class NEWS_SUMMARY_TOLOKA_PREPROCESSOR_RUN_TEMPLATE(sdk2.Resource):
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


class NEWS_SUMMARY_TOLOKA_PREPROCESSOR_CONFIG(sdk2.Resource):
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


class BuildNewsSummaryTolokaPreprocessorServiceConfigs(BuildNewsServiceConfigBundleBase):
    """Build bundle with config files and scripts for Nanny service of news summary_toloka_preprocessor"""

    type = "BUILD_NEWS_SUMMARY_TOLOKA_PREPROCESSOR_SERVICE_CONFIGS"

    NEWS_CONFIG_RESOURCES = {
        "run_template.sh": NEWS_SUMMARY_TOLOKA_PREPROCESSOR_RUN_TEMPLATE,
        "config.pbtxt.tmpl": NEWS_SUMMARY_TOLOKA_PREPROCESSOR_CONFIG,
    }


__Task__ = BuildNewsSummaryTolokaPreprocessorServiceConfigs
