# -*- coding: utf-8 -*-

from sandbox import sdk2
from sandbox.projects import resource_types
from sandbox.projects.news.BuildNewsServiceConfigBundleBase import BuildNewsServiceConfigBundleBase


class NEWS_SUMMARY_YT_UPDATER_RUN_TEMPLATE(sdk2.Resource):
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


class NEWS_SUMMARY_YT_UPDATER_CONFIG_TEMPLATE(sdk2.Resource):
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


class NEWS_SUMMARY_YT_UPDATER_EXP_CONFIG_TEMPLATE(sdk2.Resource):
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


class NEWS_SUMMARY_YT_UPDATER_CLUSTERING_EXP_CONFIG_TEMPLATE(sdk2.Resource):
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


class BuildNewsSummaryYtUpdaterServiceConfigs(BuildNewsServiceConfigBundleBase):
    """Build bundle with config files and scripts for Nanny service of news summary_yt_updater"""

    type = "BUILD_NEWS_SUMMARY_YT_UPDATER_SERVICE_CONFIGS"

    NEWS_CONFIG_RESOURCES = {
        "run_template.sh": NEWS_SUMMARY_YT_UPDATER_RUN_TEMPLATE,
        "config.json.tmpl": NEWS_SUMMARY_YT_UPDATER_CONFIG_TEMPLATE,
        "config_exp.json.tmpl": NEWS_SUMMARY_YT_UPDATER_EXP_CONFIG_TEMPLATE,
        "config_clustering_exp.json.tmpl": NEWS_SUMMARY_YT_UPDATER_CLUSTERING_EXP_CONFIG_TEMPLATE,
    }


__Task__ = BuildNewsSummaryYtUpdaterServiceConfigs
