# -*- coding: utf-8 -*-

from sandbox.sdk2.resource import AbstractResource

from sandbox.projects import resource_types
from sandbox.projects.common.build.CommonBuildTask import CommonBuildTask
from sandbox.projects.news.resources import NEWS_TKVA_EVLOGDUMP_EXECUTABLE


class NEWS_TKVA_BIN_EXECUTABLE(AbstractResource):
    """"""
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


class BuildNewsTkva(CommonBuildTask):
    """"""

    type = 'BUILD_NEWS_TKVA'

    TARGET_RESOURCES = (
        (NEWS_TKVA_BIN_EXECUTABLE, 'yweb/news/tkva/tkva'),
        (NEWS_TKVA_EVLOGDUMP_EXECUTABLE, 'yweb/news/tkva/evlogdump/evlogdump_tkva'),
    )


__Task__ = BuildNewsTkva
