# -*- coding: utf-8 -*-

import os
from sandbox.projects import resource_types
from sandbox.projects.news import resources

from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess as sp

from sandbox.sandboxsdk.paths import make_folder
from sandbox.projects.common.nanny import nanny


class BuildNewsUatraitsBundle(nanny.ReleaseToNannyTask2, sdk2.Task):
    """
    """

    def loadFile(self, file_name, resourseType):
        command_template = 'curl -vkL "https://raw.github.yandex-team.ru/InfraComponents/uatraits-data/master/data/{}" > "{}"'

        sp.Popen(command_template.format(file_name, file_name), shell=True).wait()

        resource = resourseType(self, "News uatraits resource", 'workcopy/{}'.format(file_name))
        resourceData = sdk2.ResourceData(resource)
        resourceData.ready()

        return resource

    def on_execute(self):
        workcopy_dir = self.path().joinpath('workcopy')
        make_folder(workcopy_dir)
        os.chdir(workcopy_dir.stem)

        self.loadFile('browser.xml', resource_types.NEWS_UATRAITS_BROWSER_XML)

        self.loadFile('profiles.xml', resources.NEWS_UATRAITS_PROFILES_XML)

        self.loadFile('extra.xml', resources.NEWS_UATRAITS_EXTRA_XML)
