# -*- coding: utf-8 -*-
from sandbox.sdk2.resource import AbstractResource
from sandbox.projects.common.build.CommonBuildTask import CommonBuildTask
from sandbox.projects.common.nanny import nanny


class SKYBIT_LOG_COLLECTOR_EXECUTABLE(AbstractResource):
    """Skybit log collector daemon executable."""
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = ['myoroff']


class BuildSkybitLogCollector(nanny.ReleaseToNannyTask, CommonBuildTask):
    """Build skybit log collector daemon."""
    type = 'BUILD_SKYBIT_LOG_COLLECTOR'

    TARGET_RESOURCES = (
        (SKYBIT_LOG_COLLECTOR_EXECUTABLE, 'yweb/news/skybit/log_collector/skybit_log_collector'),
    )


__Task__ = BuildSkybitLogCollector
