# -*- coding: utf-8 -*-

from sandbox.projects.news.BuildNewsServiceConfigBundleBase import \
    BuildNewsServiceConfigBundleBase,\
    NewsResourcesArcadiaPath
from sandbox.projects.resource_types import sport_news_releasers, AbstractResource


class SPORT_CLUSTERD_INSTANCECTL_CONF(AbstractResource):
    """
        News clusterd inctancectl.conf
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = sport_news_releasers


class SPORT_CLUSTER_CLUSTERD_CONF(AbstractResource):
    """
        News clusterd production config
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = sport_news_releasers


class ClusterdConfPath(NewsResourcesArcadiaPath):
    description = 'clusterd config url:'
    default_value = 'svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/sport/news/config/clusterd'


def replace(params, param):
    result = []
    for p in params:
        if param.name == p.name:
            result.append(param)
        else:
            result.append(p)
    return result


class BuildSportClusterdConfigBundle(BuildNewsServiceConfigBundleBase):
    """Build bundle with config files for news clusterd"""

    type = "BUILD_SPORT_CLUSTERD_CONFIG_BUNDLE"

    input_parameters = replace(BuildNewsServiceConfigBundleBase.input_parameters, ClusterdConfPath)

    NEWS_CONFIG_RESOURCES = {
        "instancectl.conf": SPORT_CLUSTERD_INSTANCECTL_CONF,
        "clusterd.conf": SPORT_CLUSTER_CLUSTERD_CONF,
    }


__Task__ = BuildSportClusterdConfigBundle
