# -*- coding: utf-8 -*-

import sandbox.projects.common.build.YaPackage as pkg
import sandbox.projects.common.build.parameters as build_parameters
from sandbox.projects.common.news.parameters import replace_parameters_default_value
from sandbox.projects.resource_types import sport_news_releasers
from sandbox import sdk2


class SPORT_INDEXER_PACKAGE(sdk2.resource.AbstractResource):
    """
        Архив для выкатывания на спортивный индексатор новостей
    """
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = sport_news_releasers


class BuildSportndexerPackage(pkg.YaPackage):
    """
        Build news indexer
    """

    type = 'BUILD_SPORT_INDEXER_PACKAGE'

    input_parameters = replace_parameters_default_value(pkg.YaPackage.input_parameters, {
        pkg.ResourceTypeParameter: SPORT_INDEXER_PACKAGE.name,
        pkg.PackagesParameter: "sport/news/pkg/json/indexer.json",
        pkg.PackageTypeParameter: pkg.TARBALL,
        pkg.CompressPackageArchiveParameter: False,
        pkg.UseNewFormatParameter: True,

        build_parameters.UseArcadiaApiFuse: True,
        build_parameters.UseArcInsteadOfArcadiaApi: True,
        build_parameters.AllowArcadiaApiFallback: True,
        build_parameters.BuildType: "release",
        build_parameters.OverwriteReadOnlyFiles: True,
    })


__Task__ = BuildSportndexerPackage
