# -*- coding: utf-8 -*-

from sandbox.projects.news.BuildNewsServiceConfigBundleBase import BuildNewsServiceConfigBundleBase, NewsResourcesArcadiaPath

from sandbox.projects.resource_types import sport_news_releasers

from sandbox import sdk2
AbstractResource = sdk2.resource.AbstractResource


class NewsSkybitResourcesArcadiaPath(NewsResourcesArcadiaPath):
    description = 'News package config url:'
    default_value = 'svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/sport/news/config/'


def replace(params, param):
    result = []
    for i, p in enumerate(params):
        if param.name == p.name:
            result.append(param)
        else:
            result.append(p)
    return result


class SPORT_REDIS_RESOLVER_MAPFILE(AbstractResource):
    executable = False
    auto_backup = True
    releasable = True
    releasers = sport_news_releasers


class SPORT_ZOOKEEPER_ADDRS_DEV(AbstractResource):
    executable = False
    auto_backup = True
    releasable = True
    releasers = sport_news_releasers


class SPORT_ZOOKEEPER_ADDRS_PROD(AbstractResource):
    executable = False
    auto_backup = True
    releasable = True
    releasers = sport_news_releasers


class SPORT_2LD_LIST(AbstractResource):
    executable = False
    auto_backup = True
    releasable = True
    releasers = sport_news_releasers


class BuildSportSkybitConfigBundle(BuildNewsServiceConfigBundleBase):
    """Build bundle with config files for news skybit services"""

    type = "BUILD_SPORT_SKYBIT_CONFIG_BUNDLE"

    input_parameters = replace(BuildNewsServiceConfigBundleBase.input_parameters, NewsSkybitResourcesArcadiaPath)

    NEWS_CONFIG_RESOURCES = {
        "redis_resolver_mapfile.json": SPORT_REDIS_RESOLVER_MAPFILE,
        "zookeeper_addrs_dev.txt": SPORT_ZOOKEEPER_ADDRS_DEV,
        "zookeeper_addrs_prod.txt": SPORT_ZOOKEEPER_ADDRS_PROD,
        "2ld.list": SPORT_2LD_LIST,
    }


__Task__ = BuildSportSkybitConfigBundle
