# -*- coding: utf-8 -*-

from sandbox.sandboxsdk import parameters as sp

from sandbox.projects.common.news.compare import CompareApphostResponses

from sandbox.projects.news import resources


class QueriesResourceParameter(sp.LastReleasedResource):
    name = 'queries_resource_id'
    description = 'Queries (optional)'
    resource_type = resources.ARRANGED_APPHOST_REQUESTS


class ArrangedResponses1Parameter(sp.LastReleasedResource):
    name = 'arranged_responses1_resource_id'
    description = 'Arranged responses #1'
    resource_type = resources.ARRANGED_APPHOST_RESPONSES


class ArrangedResponses2Parameter(sp.LastReleasedResource):
    name = 'arranged_responses2_resource_id'
    description = 'Arranged responses #2'
    resource_type = resources.ARRANGED_APPHOST_RESPONSES


class SaveHtmlDiffParameter(sp.SandboxBoolParameter):
    name = 'save_html_diff'
    description = 'Save html diff'
    default_value = False


def filter_debug(answer):
    if answer.get("answers"):
        for a in answer["answers"]:
            a.pop("reqid", None)
    return answer


class CompareArrangedResponses(CompareApphostResponses):
    """
        Сравнивает результаты обстрела arranged запросами из AppHost'а
        Использует результаты задачи GET_ARRANGED_APPHOST_RESPONSES
    """

    type = 'COMPARE_ARRANGED_RESPONSES'

    input_parameters = (
        QueriesResourceParameter,
        ArrangedResponses1Parameter,
        ArrangedResponses2Parameter,
        SaveHtmlDiffParameter,
    )

    def init_resource(self):
        resource = self.create_resource(
            self.descr, 'compare_result',
            resources.ARRANGED_RESPONSES_COMPARE_RESULT,
            attributes={'backup_task': True},
        )
        return resource.id

    def get_first_responses(self):
        return self.ctx[ArrangedResponses1Parameter.name]

    def get_second_responses(self):
        return self.ctx[ArrangedResponses2Parameter.name]

    def get_queries(self):
        return self.ctx[QueriesResourceParameter.name]

    def save_html(self):
        return self.ctx[SaveHtmlDiffParameter.name]

    def get_filter_debug_func(self):
        return filter_debug


__Task__ = CompareArrangedResponses
