# -*- coding: utf-8 -*-


class TemplatesLoader(object):
    def _load(self):
        import jinja2
        from library.python import resource
        self.index_template = jinja2.Template(resource.find("sandbox/projects/news/CompareNewsAnnotatorResponses/index_template.html"))
        self.diff_template = jinja2.Template(resource.find("sandbox/projects/news/CompareNewsAnnotatorResponses/diff_template.html"))

    def _get_template(self, name):
        try:
            return getattr(self, name)
        except AttributeError:
            self._load()
            return getattr(self, name)

    @property
    def index(self):
        return self._get_template("index_template")

    @property
    def diff(self):
        return self._get_template("diff_template")


Templates = TemplatesLoader()
