import json

from sandbox import sdk2
from sandbox.sandboxsdk import environments
from sandbox.sdk2.helpers import subprocess as sp, ProcessLog
from sandbox.projects.common.news import yappy as news_yappy


class CreateNewsRuntimeYappyBeta(sdk2.Task):

    environment = (
        environments.SvnEnvironment(),
    )

    class Requirements(sdk2.Task.Requirements):
        disk_space = 1 * 1024
        ram = 1 * 1024

    class Parameters(sdk2.Task.Parameters):
        description = "Task for creating yappy beta based on some beta template"

        service_name = sdk2.parameters.String(
            'Name of the service to read config from yweb/news/runtime_yappy',
            required=True
        )

        resources_to_deploy = sdk2.parameters.List(
            'Resources to deploy to beta',
            required=True
        )

        wait_timeout = sdk2.parameters.Integer(
            'Time in seconds to wait for a beta to start',
            default=1800,
            required=True
        )

    def on_execute(self):
        service_config = self.load_service_config()
        yappy_token = sdk2.Vault.data('NEWS', 'yappy_token')
        beta_suffix = 'beta' + str(self.id)
        news_yappy.create_beta_from_template(service_config, beta_suffix, self.Parameters.resources_to_deploy, yappy_token, self.Parameters.wait_timeout)

    def on_failure(self, prev_status):
        self.set_info("on_failure called")

    def on_break(self, prev_status, status):
        self.set_info("on_break called")

    def load_service_config(self):
        with ProcessLog(self, 'bash_magic.log') as pl:
            environments.SvnEnvironment().prepare()

            sp.check_call(
                ["bash", "-c", "svn cat svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/ya | python - clone"],
                stdout=pl.stdout, stderr=pl.stderr
            )

            sp.check_call(
                ["arcadia/ya", "make", "--checkout", "arcadia/yweb/news/runtime_yappy"],
                stdout=pl.stdout, stderr=pl.stderr
            )

            service_config = {}
            with open("arcadia/yweb/news/runtime_yappy/" + self.Parameters.service_name + ".json") as conf:
                service_config = json.load(conf)

            self.set_info("Full service config: " + str(json.dumps(service_config, indent=4)))
            return service_config
