# -*- coding: utf-8 -*-


import urllib2

from sandbox.sandboxsdk import parameters

from sandbox import sdk2

from sandbox.projects.news.resources import NEWS_AAB_COOKIE
from sandbox.projects.NewsAutoreleasableTask import NewsAutoreleasableTask
from sandbox.projects.NewsAutoreleasableTask import Params as NewsAutoreleasableTaskParams
from sandbox.projects.common.apihelpers import get_last_resource_with_attrs


class Params(object):
    class DownloadUrl(parameters.SandboxStringParameter):
        name = 'aab_cookie_url'
        description = 'News aab cookie download url'
        default_value = 'http://static-mon.yandex.net/cookie_of_the_day'

    params = [DownloadUrl]


class DownloadNewsAABCookie(NewsAutoreleasableTask):
    """"""

    type = "DOWNLOAD_NEWS_AAB_COOKIE"

    input_parameters = NewsAutoreleasableTaskParams.params + Params.params

    def do_execute(self):
        r = urllib2.urlopen(urllib2.Request(self.ctx.get(Params.DownloadUrl.name), headers={
            'x-aab-partnertoken': sdk2.Vault.data('NEWS', 'NEWS_AAB_TOKEN')
        }))

        aab_cookie = r.read()
        self.set_info("Current cookie: " + aab_cookie)

        old_aab_cookie_res = get_last_resource_with_attrs(
            resource_type=NEWS_AAB_COOKIE,
            attrs={'released': 'stable'}
        )

        self.set_info("Last released resource: " + str(old_aab_cookie_res))

        if old_aab_cookie_res:
            old_file = self.sync_resource(old_aab_cookie_res)
            with open(old_file, "r") as r:
                old_cookie = r.read()
                self.set_info("Last resource raw data: " + str(old_cookie))
                if old_cookie.replace("\n", "") == aab_cookie:
                    return False

        with open('news_aab_cookie.txt', "w") as w:
            w.write(aab_cookie)

        resource = self.create_resource(
            description=self.descr,
            resource_path='news_aab_cookie.txt',
            resource_type=NEWS_AAB_COOKIE,
            arch=self.arch,
            attributes={},
        )
        self.mark_resource_ready(resource.id)

        return True


__Task__ = DownloadNewsAABCookie
