# -*- coding: utf-8 -*-

import os

from sandbox.sdk2.resource import AbstractResource

from sandbox.sandboxsdk.paths import make_folder
from sandbox.sandboxsdk.process import run_process

from sandbox.projects import resource_types
from sandbox.projects.common import apihelpers

from sandbox.projects.NewsAutoreleasableTask import NewsAutoreleasableTask
from sandbox.projects.NewsAutoreleasableTask import Params as NewsAutoreleasableTaskParams


class NEWS_PERSONAL_RUBRIC_TABLE_SHARDS(AbstractResource):
    """"""
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_types.news_releasers


class DownloadNewsPersonalRubricTable(NewsAutoreleasableTask):
    """"""

    type = "DOWNLOAD_NEWS_PERSONAL_RUBRIC_TABLE"

    params = NewsAutoreleasableTaskParams.params

    def do_execute(self):
        os.environ['YT_TOKEN'] = self.get_vault_data('yt_token')

        downloader = self.sync_resource(apihelpers.get_last_resource_with_attrs(
            'NEWS_PERSONAL_RUBRIC_TABLE_DOWNLOADER_EXECUTABLE',
            {'released': 'stable'},
            all_attrs=True
        ))

        shards_dir = self.abs_path('shards')
        make_folder(shards_dir)
        os.chdir(shards_dir)

        run_process(downloader, shell=True, log_prefix="downloader_")

        resource = self.create_resource(
            description=self.descr,
            resource_path='shards',
            resource_type=NEWS_PERSONAL_RUBRIC_TABLE_SHARDS,
            arch=self.arch,
            attributes={},
        )

        self.mark_resource_ready(resource.id)

        return True


__Task__ = DownloadNewsPersonalRubricTable
