# -*- coding: utf-8 -*-


import requests

from sandbox.sandboxsdk import parameters

from sandbox.projects.news.resources import NEWS_SPORT_ENTITY_ID_MAP
from sandbox.projects.NewsAutoreleasableTask import NewsAutoreleasableTask
from sandbox.projects.NewsAutoreleasableTask import Params as NewsAutoreleasableTaskParams


class Params(object):
    class DownloadUrl(parameters.SandboxStringParameter):
        name = 'sport_api_map_url'
        description = 'Json data will be downloaded from this url'
        default_value = 'https://sport-api-test.n.yandex.ru/v2/projects/yandexsport/entity'

    class OutputFileName(parameters.SandboxStringParameter):
        name = 'output_file_name'
        description = 'Output file name'
        default_value = 'sport_entity_id_map.txt'

    params = [DownloadUrl, OutputFileName]


class DownloadNewsSportEntityIDMap(NewsAutoreleasableTask):
    """"""

    type = "DOWNLOAD_NEWS_SPORT_ENTITY_ID_MAP"

    input_parameters = NewsAutoreleasableTaskParams.params + Params.params

    def do_execute(self):
        response = requests.get(self.ctx.get(Params.DownloadUrl.name))
        response.raise_for_status()

        output_path = self.ctx.get(Params.OutputFileName.name)
        with open(output_path, "w") as filename:
            for item in response.json():
                line = "{}\t{}\t{}\t{}\n".format(item["entity_id"], item["id"], item["type"], item["sport_id"])
                filename.write(line)

        resource = self.create_resource(
            description=self.descr,
            resource_path=output_path,
            resource_type=NEWS_SPORT_ENTITY_ID_MAP,
            arch=self.arch,
            attributes={},
        )

        self.mark_resource_ready(resource.id)

        return True


__Task__ = DownloadNewsSportEntityIDMap
