# -*- coding: utf-8 -*-

import json
from urllib2 import urlopen, Request

from sandbox.sandboxsdk import parameters
from sandbox import sdk2

from sandbox.projects.news.resources import NEWS_THEMES_COMPONENTS
from sandbox.projects.NewsAutoreleasableTask import NewsAutoreleasableTask
from sandbox.projects.NewsAutoreleasableTask import Params as NewsAutoreleasableTaskParams


class Params(object):
    class ThemesAdminUrl(parameters.SandboxStringParameter):
        name = 'themes_admin_url'
        description = 'Themes admin url'
        default_value = 'http://themes.news-viewers.yandex-team.ru/'

    class ApiPath(parameters.SandboxStringParameter):
        name = 'api_path'
        description = 'API path'
        default_value = 'api/components'

    class OutputFileName(parameters.SandboxStringParameter):
        name = 'output_file_name'
        description = 'Output file name'
        default_value = 'themes_components.json'

    params = [ThemesAdminUrl, ApiPath, OutputFileName]


class DownloadNewsThemesComponents(NewsAutoreleasableTask):
    """"""

    type = "DOWNLOAD_NEWS_THEMES_COMPONENTS"

    input_parameters = NewsAutoreleasableTaskParams.params + Params.params

    themes_resource_type = NEWS_THEMES_COMPONENTS

    def do_execute(self):
        admin_url = self.ctx.get(Params.ThemesAdminUrl.name)
        api_path = self.ctx.get(Params.ApiPath.name)
        token = sdk2.Vault.data('NEWS', 'yt_token')
        request = Request(admin_url + api_path, headers={"Authorization": "OAuth {}".format(token)})
        r = urlopen(request)
        text = r.read()
        data = json.loads(text)
        for component in data["components"]:
            for annotation in component["annotations"]:
                del annotation["description"]

        output_path = self.ctx.get(Params.OutputFileName.name)
        with open(output_path, "w") as w:
            json.dump(data, w)

        resource = self.create_resource(
            description=self.descr,
            resource_path=output_path,
            resource_type=self.themes_resource_type,
            arch=self.arch,
            attributes={},
        )

        self.mark_resource_ready(resource.id)

        return True


__Task__ = DownloadNewsThemesComponents
