# -*- coding: utf-8 -*-

import json
from urllib2 import urlopen
from contextlib import closing
from socket import error as SocketError
import errno

from sandbox.sandboxsdk import parameters

from sandbox.projects.news.resources import SPORT_VIDEO_COLLECTIONS
from sandbox.projects.NewsAutoreleasableTask import NewsAutoreleasableTask
from sandbox.projects.NewsAutoreleasableTask import Params as NewsAutoreleasableTaskParams


class Params(object):
    class SportApiUrl(parameters.SandboxStringParameter):
        name = 'sport_api_url'
        description = 'Full sport api url'
        default_value = 'https://api.sport.yandex.ru/v2/projects/yandexsport/collections-list'

    class OutputFileName(parameters.SandboxStringParameter):
        name = 'output_file_name'
        description = 'Output file name'
        default_value = 'sport_video_collections.json'

    params = [SportApiUrl, OutputFileName]


class DownloadSportVideoCollections(NewsAutoreleasableTask):
    """"""

    type = "DOWNLOAD_SPORT_VIDEO_COLLECTIONS"

    input_parameters = NewsAutoreleasableTaskParams.params + Params.params

    video_resource_type = SPORT_VIDEO_COLLECTIONS

    def do_execute(self):
        def fetch(url):
            retries = 3
            last_error = None
            for i in xrange(retries):
                try:
                    with closing(urlopen(url, timeout=5)) as r:
                        return json.load(r)
                except SocketError as e:
                    if e.errno != errno.ECONNRESET:
                        raise
                    last_error = e
            raise last_error

        api_url = self.ctx.get(Params.SportApiUrl.name)
        data = fetch(api_url)
        output_path = self.ctx.get(Params.OutputFileName.name)
        with open(output_path, "w") as w:
            json.dump(data, w)

        resource = self.create_resource(
            description=self.descr,
            resource_path=output_path,
            resource_type=self.video_resource_type,
            arch=self.arch,
            attributes={},
        )

        self.mark_resource_ready(resource.id)

        return True


__Task__ = DownloadSportVideoCollections
