# -*- coding: utf-8 -*-

import logging
import os
import shutil

from sandbox import sdk2


class GetLastSuitableResource(sdk2.Task):
    class Parameters(sdk2.Parameters):
        with sdk2.parameters.Group("Common params") as common_params:
            src_type = sdk2.parameters.String("Type of required resource", required=True)
            src_attrs = sdk2.parameters.Dict("Attrs of required resource")
            dst_attrs = sdk2.parameters.Dict("New attrs")
            create_new = sdk2.parameters.Bool("Create new resource", default=False)
            with create_new.value[True]:
                dst_type = sdk2.parameters.String("Type of new resource")
                dst_ttl = sdk2.parameters.Integer('TTL', default=14)

    def on_execute(self):
        # find src resource
        src_resource = sdk2.Resource.find(type=self.Parameters.src_type, state="READY", attrs=self.Parameters.src_attrs).order(-sdk2.Resource.id).first()

        def create_attrs(resource_id):
            for name, value in self.Parameters.dst_attrs.iteritems():
                data = {'name': name, 'value': value}
                try:
                    sdk2.Task._sdk_server.resource[resource_id].attribute.create(data)
                except Exception as e:
                    logging.exception(e)
                    raise e

        if self.Parameters.create_new:
            # get resource from sandbox
            src_resource_path = sdk2.ResourceData(src_resource).path.as_posix()

            # copy data
            dst_resource_path = os.path.join(self.path().as_posix(), os.path.basename(src_resource_path))  # local destination path
            if os.path.isfile(src_resource_path):
                shutil.copy2(src_resource_path, dst_resource_path)
            else:
                shutil.copytree(src_resource_path, dst_resource_path)

            # create new resource
            dst_resource = sdk2.Resource[self.Parameters.dst_type](self, "New resource", dst_resource_path, ttl=self.Parameters.dst_ttl)

            # set attrs
            create_attrs(dst_resource.id)

            # enjoy!
            sdk2.ResourceData(dst_resource).ready()
        else:
            create_attrs(src_resource.id)
