import logging

from sandbox import sdk2
from sandbox.sandboxsdk.task import SandboxTask as OldTask


class NewsReleaseMultipleTasks(sdk2.Task):

    class Parameters(sdk2.Task.Parameters):
        tasks_to_release = sdk2.parameters.List("List of tasks to realse")
        release_status = sdk2.parameters.String("Release status")
        release_subject = sdk2.parameters.String("Release subject")

    def on_execute(self):
        for task_id in self.Parameters.tasks_to_release:
            self.set_info('Releasing task: <a href=https://sandbox.yandex-team.ru/task/{}>{}</a>'.format(task_id, task_id), do_escape=False)
            self.server.release(
                task_id=task_id,
                type=self.Parameters.release_status,
                subject=self.Parameters.release_subject
            )
