import json
import logging
from sandbox import sdk2

from sandbox.sandboxsdk.task import SandboxTask as OldTask
from sandbox.projects.news.resources import RELEASERS
from sandbox.common.types import task as ctt
from sandbox.projects import resource_types


class NewsRunSandboxTaskFakeResource(sdk2.Resource):
    """
    Fake resource to activate sandbox release button
    """
    executable = False
    releasable = True
    auto_backup = False
    any_arch = True
    releasers = RELEASERS


class NewsRunSandboxTask(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        task_type = sdk2.parameters.String("Task type to run")
        child_task_parameters = sdk2.parameters.String("JSON with parameters for child task", multiline=True)

    class Context(sdk2.Context):
        child_task = None

    def on_execute(self):
        if self.Context.child_task is None:
            params = json.loads(self.Parameters.child_task_parameters)
            task_type = self.Parameters.task_type.encode('utf-8')
            task = sdk2.Task[task_type](self,
                                        description=self.Parameters.description,
                                        tags=self.Parameters.tags,
                                        **params)
            task.enqueue()
            self.Context.child_task = task.id
            self.Context.save()
            raise sdk2.WaitTask(task, ctt.Status.Group.FINISH + ctt.Status.Group.BREAK, wait_all=True)
        else:
            resource = NewsRunSandboxTaskFakeResource(self, "Fake resource", "fake_resource.txt")
            resource.path.write_bytes("Temporary hack to activate release button in sandbox. Remove after rewirte of CI pipeline")

    def on_release(self, additional_parameters):
        for child in self.find():
            OldTask(self).create_release(child,
                                         status=additional_parameters["release_status"],
                                         subject="Proxing release from parent task")
