from __future__ import print_function

import os

from sandbox.sandboxsdk.parameters import SandboxStringParameter, SandboxBoolParameter
from sandbox.projects.common import apihelpers
import sandbox.projects.common.build.parameters as build_params
from sandbox.projects.common.build.YaMake import YaMakeTask
from sandbox.projects.common import constants
from sandbox.common.types.client import Tag


class NewsHostParameter(SandboxStringParameter):
    name = 'news_host'
    description = 'News host base URL'
    default_value = 'news.noapache.priemka.yandex.tld'


class MyTestLogLevel(build_params.TestLogLevel):
    default_value = constants.INFO_TEST_LOG_LEVEL


class IsMonitoring(SandboxBoolParameter):
    description = "Run in monitoring mode"
    name = 'monitoring'


class NewsTests(YaMakeTask):
    """Run news tests."""
    type = 'NEWS_TESTS'
    client_tags = Tag.GENERIC & Tag.LINUX_PRECISE
    cores = 24

    input_parameters = [
        build_params.ArcadiaUrl,
        NewsHostParameter,
        MyTestLogLevel,
        IsMonitoring
    ]

    def initCtx(self):
        YaMakeTask.initCtx(self)
        return dict(kill_timeout=30 * 60)

    def pre_build(self, source_dir):
        self.ctx[constants.TESTS_REQUESTED] = True
        self.ctx[constants.ALLURE_REPORT] = True

        resource = apihelpers.get_last_resource_with_attrs('NEWS_REPORT_DATA',
                                                           {'released': 'stable', 'news_cluster': 'prod'},
                                                           all_attrs=True)
        resources_path = self.sync_resource(resource)
        newsdata2_path = os.path.join(resources_path, "newsdata2.json")

        test_params = {'news_host': self.ctx['news_host'],
                       'newsdata2path': newsdata2_path}
        if self.ctx['monitoring']:
            test_params['monitoring'] = 1

        self.ctx[constants.TEST_PARAMS_KEY] = " ".join("{}={}".format(key, value)
                                                       for key, value in test_params.iteritems())

    def get_targets(self):
        return ['yweb/news/tests', ]
