# -*- coding: utf-8 -*-

import os

from sandbox.sdk2.resource import AbstractResource

from sandbox.sandboxsdk.paths import make_folder
from sandbox.sandboxsdk.process import run_process

from sandbox.projects import resource_types
from sandbox.projects.common import apihelpers
from sandbox.projects.common.BaseReportShardTask import getClassesByResources

from sandbox.projects.NewsAutoreleasableTask import NewsAutoreleasableTask
from sandbox.projects.NewsAutoreleasableTask import Params as NewsAutoreleasableTaskParams


class NEWS_RTCC_BUNDLE_TKVA(AbstractResource):
    """"""
    executable = False
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = resource_types.news_releasers


class PatchNewsRTCCBundle(NewsAutoreleasableTask):
    """"""

    type = "PATCH_NEWS_RTCC_BUNDLE"

    input_parameters = NewsAutoreleasableTaskParams.params + getClassesByResources(['RTCC_BUNDLE'])

    def do_execute(self):
        patcher = self.sync_resource(apihelpers.get_last_resource_with_attrs(
            'NEWS_RTCC_BUNDLE_PATCHER_EXECUTABLE',
            {'released': 'stable'},
            all_attrs=True
        ))

        rtcc_bundle_path = self.sync_resource(self.ctx.get('res_rtcc_bundle'))
        make_folder(self.abs_path('env'))

        for env in ['tkva']:
            env_path = os.path.join('env', env)
            abs_env_path = self.abs_path(env_path)

            make_folder(abs_env_path)

            run_process('rsync -vrt --chmod=a+rw {} {}'.format(rtcc_bundle_path, os.path.join(abs_env_path, '')), shell=True, log_prefix="rsync_{}".format(env))
            run_process('{} --rtcc_bundle_dir {} --rule {}'.format(patcher, os.path.join(abs_env_path, os.path.basename(rtcc_bundle_path)), env), shell=True, log_prefix="patcher_{}".format(env))

            resource = self.create_resource(
                description=self.descr,
                resource_path=os.path.join(env_path, os.path.basename(rtcc_bundle_path)),
                resource_type=globals()['NEWS_RTCC_BUNDLE_{}'.format(env.upper())],
                arch=self.arch,
                attributes={},
            )

            self.mark_resource_ready(resource.id)

        return True


__Task__ = PatchNewsRTCCBundle
